#ifndef __CANOPEN_SLAVE_ERROR_H
#define __CANOPEN_SLAVE_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CANopen Slave
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CANOPEN_SLAVE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CANOPEN_SLAVE_COMMAND_INVALID ((TLR_RESULT)0xC0430001L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_PACKET_LENGTH
//
// MessageText:
//
//  Invalid length in packet.
//
#define TLR_E_CANOPEN_SLAVE_PACKET_LENGTH ((TLR_RESULT)0xC0430002L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_DATA_COUNT
//
// MessageText:
//
//  Invalid data count.
//
#define TLR_E_CANOPEN_SLAVE_DATA_COUNT   ((TLR_RESULT)0xC0430003L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_DATA_OFFSET
//
// MessageText:
//
//  Invalid data offset.
//
#define TLR_E_CANOPEN_SLAVE_DATA_OFFSET  ((TLR_RESULT)0xC0430004L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_DATA_COUNT_WITH_OFFSET
//
// MessageText:
//
//  Invalid data count in combination with offset.
//
#define TLR_E_CANOPEN_SLAVE_DATA_COUNT_WITH_OFFSET ((TLR_RESULT)0xC0430005L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_MODE
//
// MessageText:
//
//  Invalid mode in command.
//
#define TLR_E_CANOPEN_SLAVE_MODE         ((TLR_RESULT)0xC0430006L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_STATE
//
// MessageText:
//
//  Command is not allowed in current state.
//
#define TLR_E_CANOPEN_SLAVE_STATE        ((TLR_RESULT)0xC0430007L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_REQUEST_RUNNING
//
// MessageText:
//
//  A request is already running.
//
#define TLR_E_CANOPEN_SLAVE_REQUEST_RUNNING ((TLR_RESULT)0xC0430008L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_BUS_RUNNING
//
// MessageText:
//
//  Command is not allowed because CANopen is running.
//
#define TLR_E_CANOPEN_SLAVE_BUS_RUNNING  ((TLR_RESULT)0xC0430009L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_BUS_PARAM_ALREADY_SET
//
// MessageText:
//
//  Bus parameters are already configured.
//
#define TLR_E_CANOPEN_SLAVE_BUS_PARAM_ALREADY_SET ((TLR_RESULT)0xC043000AL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_LOCAL_NODE_ID
//
// MessageText:
//
//  Invalid Node ID for CANopen Slave.
//
#define TLR_E_CANOPEN_SLAVE_LOCAL_NODE_ID ((TLR_RESULT)0xC043000BL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_BAUDRATE
//
// MessageText:
//
//  Invalid Baudrate.
//
#define TLR_E_CANOPEN_SLAVE_BAUDRATE     ((TLR_RESULT)0xC043000CL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_29BIT_SELECTOR
//
// MessageText:
//
//  Invaiid parameter for 29 bit selector.
//
#define TLR_E_CANOPEN_SLAVE_29BIT_SELECTOR ((TLR_RESULT)0xC043000DL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_WATCHDOG_FAIL
//
// MessageText:
//
//  Watchdog failure detected.
//
#define TLR_E_CANOPEN_SLAVE_WATCHDOG_FAIL ((TLR_RESULT)0xC043000EL)

//
// MessageId: TLR_I_CANOPEN_SLAVE_ALREADY_IN_STATE
//
// MessageText:
//
//  Slave is already in requested state.
//
#define TLR_I_CANOPEN_SLAVE_ALREADY_IN_STATE ((TLR_RESULT)0x4043000FL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_SEND_EMCY
//
// MessageText:
//
//  Send emergency-telegram failed.
//
#define TLR_E_CANOPEN_SLAVE_SEND_EMCY    ((TLR_RESULT)0xC0430010L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INIT_LIB
//
// MessageText:
//
//  Failed to initialize CANopen library.
//
#define TLR_E_CANOPEN_SLAVE_INIT_LIB     ((TLR_RESULT)0xC0430011L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_ERROR_PASSIVE
//
// MessageText:
//
//  CANopen is in error-passive state.
//
#define TLR_E_CANOPEN_SLAVE_ERROR_PASSIVE ((TLR_RESULT)0xC0430012L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_BUS_OFF
//
// MessageText:
//
//  CANopen is in bus-off state.
//
#define TLR_E_CANOPEN_SLAVE_BUS_OFF      ((TLR_RESULT)0xC0430013L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_PUT_OBJECT_DATA
//
// MessageText:
//
//  Failed to write object data.
//
#define TLR_E_CANOPEN_SLAVE_PUT_OBJECT_DATA ((TLR_RESULT)0xC0430014L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_SET_OBJECT_DATA_VALID
//
// MessageText:
//
//  Language        = English
//  Failed to set object data valid.
//
#define TLR_E_CANOPEN_SLAVE_SET_OBJECT_DATA_VALID ((TLR_RESULT)0xC0430015L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_GET_OBJECT_DATA
//
// MessageText:
//
//  Failed to get object data.
//
#define TLR_E_CANOPEN_SLAVE_GET_OBJECT_DATA ((TLR_RESULT)0xC0430016L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_WRITE_PDO_REQ
//
// MessageText:
//
//  Failed to transmit PDO.
//
#define TLR_E_CANOPEN_SLAVE_WRITE_PDO_REQ ((TLR_RESULT)0xC0430017L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_GUARD_ERROR
//
// MessageText:
//
//  Guard error detected.
//
#define TLR_E_CANOPEN_SLAVE_GUARD_ERROR  ((TLR_RESULT)0xC0430018L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INIT_BUFFER
//
// MessageText:
//
//  Initialization of buffer failed.
//
#define TLR_E_CANOPEN_SLAVE_INIT_BUFFER  ((TLR_RESULT)0xC0430019L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_DL_REQ_FAILED
//
// MessageText:
//
//  CAN-DL request failed.
//
#define TLR_E_CANOPEN_SLAVE_DL_REQ_FAILED ((TLR_RESULT)0xC043001AL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_INDEX
//
// MessageText:
//
//  Invalid object index.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_INDEX ((TLR_RESULT)0xC043001BL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_SUB_INDEX
//
// MessageText:
//
//  Invalid object index.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_SUB_INDEX ((TLR_RESULT)0xC043001CL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_MAP_LENGTH
//
// MessageText:
//
//  Invalid mapping length.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_MAP_LENGTH ((TLR_RESULT)0xC043001DL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_PDO_MODE
//
// MessageText:
//
//  Invalid transmission mode for PDO.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_PDO_MODE ((TLR_RESULT)0xC043001EL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_PDO_LENGTH
//
// MessageText:
//
//  Invalid length for PDO.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_PDO_LENGTH ((TLR_RESULT)0xC043001FL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_NO_WRITE_PERM
//
// MessageText:
//
//  No write permission for object.
//
#define TLR_E_CANOPEN_SLAVE_NO_WRITE_PERM ((TLR_RESULT)0xC0430020L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_NO_READ_PERM
//
// MessageText:
//
//  No read permission for object.
//
#define TLR_E_CANOPEN_SLAVE_NO_READ_PERM ((TLR_RESULT)0xC0430021L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_VALUE_TOO_LOW
//
// MessageText:
//
//  Value for object too low.
//
#define TLR_E_CANOPEN_SLAVE_VALUE_TOO_LOW ((TLR_RESULT)0xC0430022L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_VALUE_TOO_HIGH
//
// MessageText:
//
//  Value for object too high.
//
#define TLR_E_CANOPEN_SLAVE_VALUE_TOO_HIGH ((TLR_RESULT)0xC0430023L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_PARAMETER
//
// MessageText:
//
//  Invalid parameter for object.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_PARAMETER ((TLR_RESULT)0xC0430024L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INVALID_PDO_STATE
//
// MessageText:
//
//  Invalid PDO state.
//
#define TLR_E_CANOPEN_SLAVE_INVALID_PDO_STATE ((TLR_RESULT)0xC0430025L)

//
// MessageId: TLR_I_CANOPEN_SLAVE_INITIALIZE
//
// MessageText:
//
//  Slave is initializing.
//
#define TLR_I_CANOPEN_SLAVE_INITIALIZE   ((TLR_RESULT)0x40430026L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_OBJECT_SIZE
//
// MessageText:
//
//  Invalid size for object.
//
#define TLR_E_CANOPEN_SLAVE_OBJECT_SIZE  ((TLR_RESULT)0xC0430027L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_ID_IN_USE
//
// MessageText:
//
//  Idendtifier already in use.
//
#define TLR_E_CANOPEN_SLAVE_ID_IN_USE    ((TLR_RESULT)0xC0430028L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_INHIBIT
//
// MessageText:
//
//  Service is inhibited.
//
#define TLR_E_CANOPEN_SLAVE_INHIBIT      ((TLR_RESULT)0xC0430029L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_TX_OVERRUN
//
// MessageText:
//
//  Transmit overrun.
//
#define TLR_E_CANOPEN_SLAVE_TX_OVERRUN   ((TLR_RESULT)0xC043002AL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_RX_OVERRUN
//
// MessageText:
//
//  Receive overrun.
//
#define TLR_E_CANOPEN_SLAVE_RX_OVERRUN   ((TLR_RESULT)0xC043002BL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_ERROR_WARNING
//
// MessageText:
//
//  CANopen is in error-warning state.
//
#define TLR_E_CANOPEN_SLAVE_ERROR_WARNING ((TLR_RESULT)0xC043002CL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_RECV_PDO_REQ
//
// MessageText:
//
//  Request receive PDO failed.
//
#define TLR_E_CANOPEN_SLAVE_RECV_PDO_REQ ((TLR_RESULT)0xC043002DL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_NUM_OF_RX_PDO_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of receive PDO.
//
#define TLR_E_CANOPEN_SLAVE_NUM_OF_RX_PDO_PARAMETER ((TLR_RESULT)0xC043002EL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_NUM_OF_TX_PDO_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of send PDO.
//
#define TLR_E_CANOPEN_SLAVE_NUM_OF_TX_PDO_PARAMETER ((TLR_RESULT)0xC043002FL)

//
// MessageId: TLR_E_CANOPEN_SLAVE_HB_CONSUMER_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of heartbeat consumer.
//
#define TLR_E_CANOPEN_SLAVE_HB_CONSUMER_PARAMETER ((TLR_RESULT)0xC0430030L)

//
// MessageId: TLR_E_CANOPEN_SLAVE_SEND_TIME_STAMP
//
// MessageText:
//
//  Failed to send timestamp message.
//
#define TLR_E_CANOPEN_SLAVE_SEND_TIME_STAMP ((TLR_RESULT)0xC0430031L)




#endif  //__CANOPEN_SLAVE_ERROR_H

